#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "IntersectCircles", Category = "2d", Help = "Basic template with one value in/out", Tags = "")]
	#endregion PluginInfo
	public class C2dIntersectCirclesNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Center 1 ")]
		ISpread<Vector2D> FCenter1;
		
		[Input("Radius 1", DefaultValue = 1.0)]
		ISpread<double> FRadius1;
		
		[Input("Center 2 ")]
		ISpread<Vector2D> FCenter2;
		
		[Input("Radius 2", DefaultValue = 1.0)]
		ISpread<double> FRadius2;
		
		[Output("Intersection 1 ")]
		ISpread<Vector2D> FIntersection1;
		
		[Output("Intersection 2 ")]
		ISpread<Vector2D> FIntersection2;
		
		[Output("Number of Solutions")]
		ISpread<int> FSolutionCount;
		
		[Import()]
		ILogger FLogger;
		#endregion fields & pins
		
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FIntersection1.SliceCount = SpreadMax;
			FIntersection2.SliceCount = SpreadMax;
			FSolutionCount.SliceCount = SpreadMax;
			
			for (int i = 0; i < SpreadMax; i++)
			{
				Vector2D s1;
				Vector2D s2;
				
				FSolutionCount[i] = CircleIntersection(FCenter1[i], FRadius1[i], FCenter2[i], FRadius2[i], out s1, out s2);
				FIntersection1[i] = s1;
				FIntersection2[i] = s2;
			}
			
			//FLogger.Log(LogType.Debug, "hi tty!");
		}
		
		private int CircleIntersection (Vector2D c1, double c1r, Vector2D c2, double c2r, out Vector2D p1, out Vector2D p2)
		{
			p1 = new Vector2D();
			p2 = new Vector2D();
			
			//Calculate distance between centres of circle
			double d = !(c1 - c2);
			double m = c1r + c2r;
			double n = c1r - c2r;
			
			if (n < 0)
				n = n * -1;
			
			//No solns
			if ( d > m )
				return 0;
			
			//Circle are contained within each other
			if ( d < n )
				return 0;
			
			//Circles are the same
			if ( d == 0 && c1r == c2r )
				return 0;
			
			//Solve for a
			double a = ( c1r * c1r - c2r * c2r + d * d ) / (2 * d);
			
			//Solve for h
			double h = Math.Sqrt( c1r * c1r - a * a );
			
			//Calculate point p, where the line through the circle intersection points crosses the line between the circle centers.
			Vector2D p;
			
			p.x = c1.x + ( a / d ) * ( c2.x -c1.x );
			p.y = c1.y + ( a / d ) * ( c2.y -c1.y );
			
			//1 soln , circles are touching
			if ( d == c1r + c2r ) 
			{
				p1 = p;
				return 1;
			}
			
			//2solns			
			p1.x = p.x + ( h / d ) * ( c2.y - c1.y );
			p1.y = p.y - ( h / d ) * ( c2.x - c1.x );
			
			p2.x = p.x - ( h / d ) * ( c2.y - c1.y );
			p2.y = p.y + ( h / d ) * ( c2.x - c1.x );
			
			return 2;
		}
		
	}
}
